#include "main.h"
#include "menu.h"
#include "functions.h"

Menu::Menu ()
{
	dwarfsLeft = 10;
	mouseHovering = 0;
	money = 90;
	DwarfInfo = new Dwarf[dwarfsLeft];
	DwarfID = new GLuint[7];

	WeatherForecast = rand() % 5 + 1;

	// Fill in dwarf position
	for (int i = 0; i < dwarfsLeft; i++)
	{
		DwarfInfo[i].xPos = -2.35f+0.5f*i;
		DwarfInfo[i].yPos = -1.0f;
		DwarfInfo[i].xDest = 0.0f;
		DwarfInfo[i].yDest = 0.0f;
		DwarfInfo[i].selected = false;
		DwarfInfo[i].status = 0;
	}

	BuildTexture("umbr.gif",Umbrella);
	BuildTexture("house.gif",MetalHouse);
	BuildTexture("cloth.gif",Clothes);
	BuildTexture("sun.gif",Sun);
	BuildTexture("shoe.gif",Shoes);

	BuildTexture("tumbr.gif",tUmbrella);
	BuildTexture("thouse.gif",tMetalHouse);
	BuildTexture("tcloth.gif",tClothes);
	BuildTexture("tsun.gif",tSun);
	BuildTexture("tlead.gif",tShoes);
	BuildTexture("tinfo.gif",tInfo);

	BuildTexture("tupgrd.gif",tUpgrade);

	BuildTexture("dvergur.gif",DwarfID[0]);
	BuildTexture("dumbr.gif",DwarfID[1]);
	BuildTexture("dhouse.gif",DwarfID[2]);
	BuildTexture("dcloth.gif",DwarfID[3]);
	BuildTexture("dsun.gif",DwarfID[4]);	
	BuildTexture("dshoe.gif",DwarfID[5]);
	BuildTexture("ddaudur.gif",DwarfID[6]);

	BuildTexture("numbers.gif",numbers);

	if (WeatherForecast == 1)
		BuildTexture("wrain.gif",WeatherForecastTex);
	else if (WeatherForecast == 2)
		BuildTexture("wthrumur.gif",WeatherForecastTex);
	else if (WeatherForecast == 3)
		BuildTexture("wsnow.gif",WeatherForecastTex);
	else if (WeatherForecast == 4)
		BuildTexture("wsun.gif",WeatherForecastTex);
	else if (WeatherForecast == 5)
		BuildTexture("wwind.gif",WeatherForecastTex);

	BuildTexture("proceed.gif",ProceedBtn);
}


void Menu::makeReady(Dwarf *ptrDwarfInfo)
{
	DwarfInfo = ptrDwarfInfo;

	mouseHovering = 0;

	WeatherForecast = rand() % 5 + 1;

	// Fill in dwarf position
	for (int i = 0; i < dwarfsLeft; i++)
	{
		DwarfInfo[i].xPos = -2.35f+0.5f*i;
		DwarfInfo[i].yPos = -1.0f;
		DwarfInfo[i].xDest = 0.0f;
		DwarfInfo[i].yDest = 0.0f;
		if (DwarfInfo[i].status != 6)
			money += 10;
	}

}

void Menu::drawMenu()
{
	int i = 0;
	glColor3f(1.0f,1.0f,1.0f);

	glBegin(GL_QUADS);
	// Draw a white background
	// -----------------------
	for (i = 0; i < dwarfsLeft; i++)
	{
			// The dwarf
			glVertex2f(DwarfInfo[i].xPos-0.2f,DwarfInfo[i].yPos);
			glVertex2f(DwarfInfo[i].xPos+0.2f,DwarfInfo[i].yPos);
			glVertex2f(DwarfInfo[i].xPos+0.2f,DwarfInfo[i].yPos+0.6f);
			glVertex2f(DwarfInfo[i].xPos-0.2f,DwarfInfo[i].yPos+0.6f);
			if (DwarfInfo[i].status == 1)
				glColor3f(1.0f,0.0f,0.0f);
			// Umbrella
			glVertex2f(DwarfInfo[i].xPos-0.2f,DwarfInfo[i].yPos-0.1f);
			glVertex2f(DwarfInfo[i].xPos-0.02f,DwarfInfo[i].yPos-0.1f);
			glVertex2f(DwarfInfo[i].xPos-0.02f,DwarfInfo[i].yPos-0.28f);
			glVertex2f(DwarfInfo[i].xPos-0.2f,DwarfInfo[i].yPos-0.28f);
			if (DwarfInfo[i].status == 1)
				glColor3f(1.0f,1.0f,1.0f);
			else if (DwarfInfo[i].status == 2)
				glColor3f(1.0f,0.0f,0.0f);
			// Metal House
			glVertex2f(DwarfInfo[i].xPos+0.2f,DwarfInfo[i].yPos-0.3f);
			glVertex2f(DwarfInfo[i].xPos+0.02f,DwarfInfo[i].yPos-0.3f);
			glVertex2f(DwarfInfo[i].xPos+0.02f,DwarfInfo[i].yPos-0.48f);
			glVertex2f(DwarfInfo[i].xPos+0.2f,DwarfInfo[i].yPos-0.48f);
			if (DwarfInfo[i].status == 2)
				glColor3f(1.0f,1.0f,1.0f);
			else if (DwarfInfo[i].status == 3)
				glColor3f(1.0f,0.0f,0.0f);
			// Clothes
			glVertex2f(DwarfInfo[i].xPos-0.2f,DwarfInfo[i].yPos-0.5f);
			glVertex2f(DwarfInfo[i].xPos-0.02f,DwarfInfo[i].yPos-0.5f);
			glVertex2f(DwarfInfo[i].xPos-0.02f,DwarfInfo[i].yPos-0.68f);
			glVertex2f(DwarfInfo[i].xPos-0.2f,DwarfInfo[i].yPos-0.68f);
			if (DwarfInfo[i].status == 3)
				glColor3f(1.0f,1.0f,1.0f);
			else if (DwarfInfo[i].status == 4)
				glColor3f(1.0f,0.0f,0.0f);
			// Sunbonnet
			glVertex2f(DwarfInfo[i].xPos+0.2f,DwarfInfo[i].yPos-0.7f);
			glVertex2f(DwarfInfo[i].xPos+0.02f,DwarfInfo[i].yPos-0.7f);
			glVertex2f(DwarfInfo[i].xPos+0.02f,DwarfInfo[i].yPos-0.88f);
			glVertex2f(DwarfInfo[i].xPos+0.2f,DwarfInfo[i].yPos-0.88f);
			if (DwarfInfo[i].status == 4)
				glColor3f(1.0f,1.0f,1.0f);
			else if (DwarfInfo[i].status == 5)
				glColor3f(1.0f,0.0f,0.0f);
			// Shoes
			glVertex2f(DwarfInfo[i].xPos-0.2f,DwarfInfo[i].yPos-0.9f);
			glVertex2f(DwarfInfo[i].xPos-0.02f,DwarfInfo[i].yPos-0.9f);
			glVertex2f(DwarfInfo[i].xPos-0.02f,DwarfInfo[i].yPos-1.08f);
			glVertex2f(DwarfInfo[i].xPos-0.2f,DwarfInfo[i].yPos-1.08f);
			if (DwarfInfo[i].status == 5)
				glColor3f(1.0f,1.0f,1.0f);
	}
	glEnd();

	// Draw Dwarfs
	// -----------
	glEnable(GL_TEXTURE_2D);
	for (i = 0; i < dwarfsLeft; i++)
	{
		glBindTexture(GL_TEXTURE_2D, DwarfID[DwarfInfo[i].status]);
		glBegin(GL_QUADS);
			glTexCoord2f(0.0f,0.0f);	glVertex2f(DwarfInfo[i].xPos-0.2f,DwarfInfo[i].yPos);
			glTexCoord2f(1.0f,0.0f); 	glVertex2f(DwarfInfo[i].xPos+0.2f,DwarfInfo[i].yPos);
			glTexCoord2f(1.0f,1.0f); 	glVertex2f(DwarfInfo[i].xPos+0.2f,DwarfInfo[i].yPos+0.6f);
			glTexCoord2f(0.0f,1.0f);	glVertex2f(DwarfInfo[i].xPos-0.2f,DwarfInfo[i].yPos+0.6f);
		glEnd();
	}

	// Draw all the upgrades beneath the dwarf
	// ---------------------------------------
	glBindTexture(GL_TEXTURE_2D, Umbrella);	
	glBegin(GL_QUADS);
	for (i = 0; i < dwarfsLeft; i++)
	{
			glTexCoord2f(1.0f,1.0f);	glVertex2f(DwarfInfo[i].xPos-0.2f,DwarfInfo[i].yPos-0.1f);
			glTexCoord2f(0.0f,1.0f);	glVertex2f(DwarfInfo[i].xPos-0.02f,DwarfInfo[i].yPos-0.1f);
			glTexCoord2f(0.0f,0.0f);	glVertex2f(DwarfInfo[i].xPos-0.02f,DwarfInfo[i].yPos-0.28f);
			glTexCoord2f(1.0f,0.0f);	glVertex2f(DwarfInfo[i].xPos-0.2f,DwarfInfo[i].yPos-0.28f);
	}
	glEnd();
	glBindTexture(GL_TEXTURE_2D, MetalHouse);	
	glBegin(GL_QUADS);
	for (i = 0; i < dwarfsLeft; i++)
	{
			glTexCoord2f(1.0f,1.0f);	glVertex2f(DwarfInfo[i].xPos+0.2f,DwarfInfo[i].yPos-0.3f);
			glTexCoord2f(0.0f,1.0f);	glVertex2f(DwarfInfo[i].xPos+0.02f,DwarfInfo[i].yPos-0.3f);
			glTexCoord2f(0.0f,0.0f);	glVertex2f(DwarfInfo[i].xPos+0.02f,DwarfInfo[i].yPos-0.48f);
			glTexCoord2f(1.0f,0.0f);	glVertex2f(DwarfInfo[i].xPos+0.2f,DwarfInfo[i].yPos-0.48f);
	}
	glEnd();
	glBindTexture(GL_TEXTURE_2D, Clothes);	
	glBegin(GL_QUADS);
	for (i = 0; i < dwarfsLeft; i++)
	{
			glTexCoord2f(1.0f,1.0f);	glVertex2f(DwarfInfo[i].xPos-0.2f,DwarfInfo[i].yPos-0.5f);
			glTexCoord2f(0.0f,1.0f);	glVertex2f(DwarfInfo[i].xPos-0.02f,DwarfInfo[i].yPos-0.5f);
			glTexCoord2f(0.0f,0.0f);	glVertex2f(DwarfInfo[i].xPos-0.02f,DwarfInfo[i].yPos-0.68f);
			glTexCoord2f(1.0f,0.0f);	glVertex2f(DwarfInfo[i].xPos-0.2f,DwarfInfo[i].yPos-0.68f);
	}
	glEnd();
	glBindTexture(GL_TEXTURE_2D, Sun);
	glBegin(GL_QUADS);
	for (i = 0; i < dwarfsLeft; i++)
	{
			glTexCoord2f(1.0f,1.0f);	glVertex2f(DwarfInfo[i].xPos+0.2f,DwarfInfo[i].yPos-0.7f);
			glTexCoord2f(0.0f,1.0f);	glVertex2f(DwarfInfo[i].xPos+0.02f,DwarfInfo[i].yPos-0.7f);
			glTexCoord2f(0.0f,0.0f);	glVertex2f(DwarfInfo[i].xPos+0.02f,DwarfInfo[i].yPos-0.88f);
			glTexCoord2f(1.0f,0.0f);	glVertex2f(DwarfInfo[i].xPos+0.2f,DwarfInfo[i].yPos-0.88f);
	}
	glEnd();
	glBindTexture(GL_TEXTURE_2D, Shoes);
	glBegin(GL_QUADS);
	for (i = 0; i < dwarfsLeft; i++)
	{
			glTexCoord2f(1.0f,1.0f);	glVertex2f(DwarfInfo[i].xPos-0.2f,DwarfInfo[i].yPos-0.9f);
			glTexCoord2f(0.0f,1.0f);	glVertex2f(DwarfInfo[i].xPos-0.02f,DwarfInfo[i].yPos-0.9f);
			glTexCoord2f(0.0f,0.0f);	glVertex2f(DwarfInfo[i].xPos-0.02f,DwarfInfo[i].yPos-1.08f);
			glTexCoord2f(1.0f,0.0f);	glVertex2f(DwarfInfo[i].xPos-0.2f,DwarfInfo[i].yPos-1.08f);
	}
	glEnd();
	glDisable(GL_TEXTURE_2D);

	// Draw Lines around dwarfs
	// ------------------------
	glColor3f(0.0f,0.0f,0.0f);
	for (i = 0; i < dwarfsLeft; i++)
	{
		glBegin(GL_LINE_LOOP);
			// The Dwarf
			glVertex2f(DwarfInfo[i].xPos-0.2f,DwarfInfo[i].yPos);
			glVertex2f(DwarfInfo[i].xPos+0.2f,DwarfInfo[i].yPos);
			glVertex2f(DwarfInfo[i].xPos+0.2f,DwarfInfo[i].yPos+0.6f);
			glVertex2f(DwarfInfo[i].xPos-0.2f,DwarfInfo[i].yPos+0.6f);
		glEnd();
		glBegin(GL_LINE_LOOP);
			// Umbrella
			glVertex2f(DwarfInfo[i].xPos-0.2f,DwarfInfo[i].yPos-0.1f);
			glVertex2f(DwarfInfo[i].xPos-0.02f,DwarfInfo[i].yPos-0.1f);
			glVertex2f(DwarfInfo[i].xPos-0.02f,DwarfInfo[i].yPos-0.28f);
			glVertex2f(DwarfInfo[i].xPos-0.2f,DwarfInfo[i].yPos-0.28f);
		glEnd();
		glBegin(GL_LINE_LOOP);
			// Metal House
			glVertex2f(DwarfInfo[i].xPos+0.2f,DwarfInfo[i].yPos-0.3f);
			glVertex2f(DwarfInfo[i].xPos+0.02f,DwarfInfo[i].yPos-0.3f);
			glVertex2f(DwarfInfo[i].xPos+0.02f,DwarfInfo[i].yPos-0.48f);
			glVertex2f(DwarfInfo[i].xPos+0.2f,DwarfInfo[i].yPos-0.48f);
		glEnd();
		glBegin(GL_LINE_LOOP);
			// Clothes
			glVertex2f(DwarfInfo[i].xPos-0.2f,DwarfInfo[i].yPos-0.5f);
			glVertex2f(DwarfInfo[i].xPos-0.02f,DwarfInfo[i].yPos-0.5f);
			glVertex2f(DwarfInfo[i].xPos-0.02f,DwarfInfo[i].yPos-0.68f);
			glVertex2f(DwarfInfo[i].xPos-0.2f,DwarfInfo[i].yPos-0.68f);
		glEnd();
		glBegin(GL_LINE_LOOP);
			// Sunbonnet
			glVertex2f(DwarfInfo[i].xPos+0.2f,DwarfInfo[i].yPos-0.7f);
			glVertex2f(DwarfInfo[i].xPos+0.02f,DwarfInfo[i].yPos-0.7f);
			glVertex2f(DwarfInfo[i].xPos+0.02f,DwarfInfo[i].yPos-0.88f);
			glVertex2f(DwarfInfo[i].xPos+0.2f,DwarfInfo[i].yPos-0.88f);
		glEnd();
		glBegin(GL_LINE_LOOP);	
			// Shoes
			glVertex2f(DwarfInfo[i].xPos-0.2f,DwarfInfo[i].yPos-0.9f);
			glVertex2f(DwarfInfo[i].xPos-0.02f,DwarfInfo[i].yPos-0.9f);
			glVertex2f(DwarfInfo[i].xPos-0.02f,DwarfInfo[i].yPos-1.08f);
			glVertex2f(DwarfInfo[i].xPos-0.2f,DwarfInfo[i].yPos-1.08f);
		glEnd();
	}
	
	// Draw the "upgrade dwarfs" caption
	// ---------------------------------
	glColor3f(1.0f,1.0f,1.0f);
	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, tUpgrade);	
	glBegin(GL_QUADS);
	for (i = 0; i < dwarfsLeft; i++)
	{
			glTexCoord2f(0.0f,1.0f);	glVertex2f(-3.0f,1.5f);
			glTexCoord2f(0.0f,0.0f); 	glVertex2f(-3.0f,0.8f);
			glTexCoord2f(1.0f,0.0f); 	glVertex2f(-0.9f,0.8f);
			glTexCoord2f(1.0f,1.0f);	glVertex2f(-0.9f,1.5f);
	}
	glEnd();

	// Draw the weather forecast
	// -------------------------
	glBindTexture(GL_TEXTURE_2D, WeatherForecastTex);	
	glBegin(GL_QUADS);
	for (i = 0; i < dwarfsLeft; i++)
	{
			glTexCoord2f(0.0f,1.0f);	glVertex2f( 0.2f,2.4f);
			glTexCoord2f(0.0f,0.0f); 	glVertex2f( 0.2f,0.6f);
			glTexCoord2f(1.0f,0.0f); 	glVertex2f( 2.22f,0.6f);
			glTexCoord2f(1.0f,1.0f);	glVertex2f( 2.22f,2.4f);
	}
	glEnd();

	// Draw the proceed button
	// -----------------------
	glBindTexture(GL_TEXTURE_2D, ProceedBtn);	
	glBegin(GL_QUADS);
	for (i = 0; i < dwarfsLeft; i++)
	{
			glTexCoord2f(0.0f,0.0f);	glVertex2f( 2.2f,-2.40f);
			glTexCoord2f(0.0f,1.0f); 	glVertex2f( 2.2f,-2.15f);
			glTexCoord2f(1.0f,1.0f); 	glVertex2f( 3.2f,-2.15f);
			glTexCoord2f(1.0f,0.0f);	glVertex2f( 3.2f,-2.40f);
	}
	glEnd();

	// Draw monehhh
	// ------------
	int a = money / 100;
	int b = (money % 100) / 10;
	int c = (money % 10);

	glBindTexture(GL_TEXTURE_2D, numbers);	
	glBegin(GL_QUADS);
		glTexCoord2f(0.000f+1.0f/11*a,1.0f);	glVertex2f( 1.3f,0.15f);
		glTexCoord2f(0.000f+1.0f/11*a,0.0f); 	glVertex2f( 1.3f,-0.15f);
		glTexCoord2f(0.091f+1.0f/11*a,0.0f); 	glVertex2f( 1.6f,-0.15f);
		glTexCoord2f(0.091f+1.0f/11*a,1.0f);	glVertex2f( 1.6f,0.15f);
		glTexCoord2f(0.000f+1.0f/11*b,1.0f);	glVertex2f( 1.6f,0.15f);
		glTexCoord2f(0.000f+1.0f/11*b,0.0f); 	glVertex2f( 1.6f,-0.15f);
		glTexCoord2f(0.091f+1.0f/11*b,0.0f); 	glVertex2f( 1.9f,-0.15f);
		glTexCoord2f(0.091f+1.0f/11*b,1.0f);	glVertex2f( 1.9f,0.15f);
		glTexCoord2f(0.000f+1.0f/11*c,1.0f);	glVertex2f( 1.9f,0.15f);
		glTexCoord2f(0.000f+1.0f/11*c,0.0f); 	glVertex2f( 1.9f,-0.15f);
		glTexCoord2f(0.091f+1.0f/11*c,0.0f); 	glVertex2f( 2.2f,-0.15f);
		glTexCoord2f(0.091f+1.0f/11*c,1.0f);	glVertex2f( 2.2f,0.15f);
		// The dollar sign
		glTexCoord2f(0.91f,1.0f);	glVertex2f( 1.0f,0.15f);
		glTexCoord2f(0.91f,0.0f); 	glVertex2f( 1.0f,-0.15f);
		glTexCoord2f(1.0f,0.0f); 	glVertex2f( 1.3f,-0.15f);
		glTexCoord2f(1.0f,1.0f);	glVertex2f( 1.3f,0.15f);
	glEnd();


	// Draw the infobox
	// ----------------
	if (mouseHovering == 0)
		glBindTexture(GL_TEXTURE_2D, tInfo);	
	else if (mouseHovering == 1)
		glBindTexture(GL_TEXTURE_2D, tUmbrella);
	else if (mouseHovering == 2)
		glBindTexture(GL_TEXTURE_2D, tMetalHouse);
	else if (mouseHovering == 3)
		glBindTexture(GL_TEXTURE_2D, tClothes);
	else if (mouseHovering == 4)
		glBindTexture(GL_TEXTURE_2D, tSun);
	else if (mouseHovering == 5)
		glBindTexture(GL_TEXTURE_2D, tShoes);

	glBegin(GL_QUADS);
	for (i = 0; i < dwarfsLeft; i++)
	{
			glTexCoord2f(0.0f,1.0f);	glVertex2f(-2.55f,0.55f);
			glTexCoord2f(0.0f,0.0f); 	glVertex2f(-2.55f,-0.15f);
			glTexCoord2f(1.0f,0.0f); 	glVertex2f(-0.0f,-0.15f);
			glTexCoord2f(1.0f,1.0f);	glVertex2f(-0.0f,0.55f);
	}
	glEnd();
	glDisable(GL_TEXTURE_2D);

	glColor3f(0.0f,0.0f,0.0f);
	glBegin(GL_LINE_LOOP);
		glVertex2f(-2.55f,0.55f);
		glVertex2f(-2.55f,-0.15f);
		glVertex2f(-0.0f,-0.15f);
		glVertex2f(-0.0f,0.55f);
	glEnd();

	// Draw lines around the cash box
	glBegin(GL_LINE_LOOP);
		glVertex2f( 1.3f,0.15f);
		glVertex2f( 1.3f,-0.15f);
		glVertex2f( 1.6f,-0.15f);
		glVertex2f( 1.6f,0.15f);
	glEnd();
	glBegin(GL_LINE_LOOP);
		glVertex2f( 1.6f,0.15f);
		glVertex2f( 1.6f,-0.15f);
		glVertex2f( 1.9f,-0.15f);
		glVertex2f( 1.9f,0.15f);
	glEnd();
	glBegin(GL_LINE_LOOP);
		glVertex2f( 1.9f,0.15f);
		glVertex2f( 1.9f,-0.15f);
		glVertex2f( 2.2f,-0.15f);
		glVertex2f( 2.2f,0.15f);
	glEnd();
	glBegin(GL_LINE_LOOP);
		glVertex2f( 1.0f,0.15f);
		glVertex2f( 1.0f,-0.15f);
		glVertex2f( 1.3f,-0.15f);
		glVertex2f( 1.3f,0.15f);
	glEnd();

}

void Menu::updMouseRect(const int x, const int y)
{
	float yReal = 2.45f-4.9f/600*y;
	float xReal = -(3.20f-6.4f/800*x);

	mouseHovering = 0;

	for (int i = 0; i < dwarfsLeft; i++)
	{
		if (xReal > -2.49f+0.485f*i && xReal < -2.31f+0.485f*i)
		{
			if (yReal < -1.1f && yReal > -1.28f)
				mouseHovering = 1;
			else if (yReal < -1.5f && yReal > -1.78f)
				mouseHovering = 3;
			else if (yReal < -1.9f && yReal > -2.08f)
				mouseHovering = 5;	
		}
		else if (xReal < -2.11f+0.485f*i && xReal > -2.29f+0.485f*i)
		{
			if (yReal < -1.3f && yReal > -1.48f)
				mouseHovering = 2;
			else if (yReal < -1.7f && yReal > -1.98f)
				mouseHovering = 4;
		}
	}
}

bool Menu::mouseClick(const int x, const int y)
{
	float yReal = 2.45f-4.9f/600*y;
	float xReal = -(3.20f-6.4f/800*x);

	for (int i = 0; i < dwarfsLeft; i++)
	{
		if (DwarfInfo[i].status != 6)
		{
			if (xReal > -2.49f+0.485f*i && xReal < -2.31f+0.485f*i)
			{
				if (yReal < -1.1f && yReal > -1.28f)
				{
					money -=10;
					if (money >= 0)
						DwarfInfo[i].status = 1;
					else
						money +=10;
				}
				else if (yReal < -1.5f && yReal > -1.78f)
				{
					money -=20;
					if (money >= 0)
						DwarfInfo[i].status = 3;
					else
						money +=20;	
				}
				else if (yReal < -1.9f && yReal > -2.08f)
				{
					money -=15;
					if (money >= 0)
						DwarfInfo[i].status = 5;	
					else
						money +=15;	
				}
			}
			else if (xReal < -2.11f+0.485f*i && xReal > -2.29f+0.485f*i)
			{
				if (yReal < -1.3f && yReal > -1.48f)
				{
					money -=20;
					if (money >= 0)
						DwarfInfo[i].status = 2;
					else
						money +=20;				
				}
				else if (yReal < -1.7f && yReal > -1.98f)
				{
					money -=10;
					if (money >= 0)
						DwarfInfo[i].status = 4;
					else
						money +=10;					
				}
			}
		}
	}

	// Check if we clicked the proceed button
	if ((xReal > 2.2f  && xReal < 3.2f ) &&
		(yReal <-2.15f && yReal >-2.40f))
		return 1;

	return 0;
}

