#include "main.h"
#include "dwarfs.h"
#include "menu.h"
#include "functions.h"

Menu *menu;
Dwarfs *dwarfs;
DWORD margin;
DWORD dimAmount;
int gameState;
GLuint splash;
GLuint gameover;
int gameOver;

void mainLoop ()
{
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);    // Clear The Screen And The Depth Buffer
    glLoadIdentity();   // Reset The View
    
	glTranslatef(0.0f,0.0f,-6.0f);

	if (gameState == 0)
	{
		menu->drawMenu();
	}
	else if (gameState == 1)
	{	
		// The Start and beginning lines
		glColor3f(0.52f,0.0f,0.0f);
		glBegin (GL_LINES);            
				glVertex3f(-2.5f, 2.45f, 0);    
				glVertex3f(-2.5f, -2.45f, 0);
				glVertex3f( 2.5f, 2.45f, 0);    
				glVertex3f( 2.5f, -2.45f, 0);
		glEnd();                
		
		dwarfs->handleEnemies(margin);
		
		gameOver = dwarfs->moveDwarfs(margin);
		if (gameOver != 0)
		{
			gameState = 31;
			dimAmount = 0;
		}


		// Dwarfs!!!
		dwarfs->drawDwarfs();
		dwarfs->drawEnemies(margin);
	}
	else if (gameState == 10)
	{ // Splashos screenos!!
		dimAmount += margin;
		glColor3f(1.0f,1.0f,1.0f);
		glEnable(GL_TEXTURE_2D);	
		glBindTexture(GL_TEXTURE_2D, splash);
		glBegin(GL_QUADS);
			glTexCoord2f(0.0f,0.0f);	glVertex2f(-2.8f,-2.1f);
			glTexCoord2f(1.0f,0.0f); 	glVertex2f(+2.8f,-2.1f);
			glTexCoord2f(1.0f,1.0f); 	glVertex2f(+2.8f,2.1f);
			glTexCoord2f(0.0f,1.0f);	glVertex2f(-2.8f,2.1f);
		glEnd();
		glDisable(GL_TEXTURE_2D);
		if (dimAmount > 25000)
		{
			gameState = 11;
			dimAmount = 0;
		}
	}
	else if (gameState == 43)
	{ // gamover :-((((
		dimAmount += margin;
		glColor3f(1.0f,1.0f,1.0f);
		glEnable(GL_TEXTURE_2D);	
		glBindTexture(GL_TEXTURE_2D, gameover);
		glBegin(GL_QUADS);
			glTexCoord2f(0.0f,0.0f);	glVertex2f(-2.8f,-1.99f);
			glTexCoord2f(1.0f,0.0f); 	glVertex2f(+2.8f,-1.99f);
			glTexCoord2f(1.0f,1.0f); 	glVertex2f(+2.8f,1.99f);
			glTexCoord2f(0.0f,1.0f);	glVertex2f(-2.8f,1.99f);
		glEnd();

		// Draw monehhh
		// ------------
		int a = menu->money / 100;
		int b = (menu->money % 100) / 10;
		int c = (menu->money % 10);

		glBindTexture(GL_TEXTURE_2D, menu->numbers);	
		glBegin(GL_QUADS);
			glTexCoord2f(0.000f+1.0f/11*a,1.0f);	glVertex2f(-0.9f,1.55f);
			glTexCoord2f(0.000f+1.0f/11*a,0.0f); 	glVertex2f(-0.9f,1.25f);
			glTexCoord2f(0.091f+1.0f/11*a,0.0f); 	glVertex2f(-0.6f,1.25f);
			glTexCoord2f(0.091f+1.0f/11*a,1.0f);	glVertex2f(-0.6f,1.55f);
			glTexCoord2f(0.000f+1.0f/11*b,1.0f);	glVertex2f(-0.6f,1.55f);
			glTexCoord2f(0.000f+1.0f/11*b,0.0f); 	glVertex2f(-0.6f,1.25f);
			glTexCoord2f(0.091f+1.0f/11*b,0.0f); 	glVertex2f(-0.3f,1.25f);
			glTexCoord2f(0.091f+1.0f/11*b,1.0f);	glVertex2f(-0.3f,1.55f);
			glTexCoord2f(0.000f+1.0f/11*c,1.0f);	glVertex2f(-0.3f,1.55f);
			glTexCoord2f(0.000f+1.0f/11*c,0.0f); 	glVertex2f(-0.3f,1.25f);
			glTexCoord2f(0.091f+1.0f/11*c,0.0f); 	glVertex2f(-0.0f,1.25f);
			glTexCoord2f(0.091f+1.0f/11*c,1.0f);	glVertex2f(-0.0f,1.55f);
			// The dollar sign
			glTexCoord2f(0.91f,1.0f);	glVertex2f(-1.2f,1.55f);
			glTexCoord2f(0.91f,0.0f); 	glVertex2f(-1.2f,1.25f);
			glTexCoord2f(1.0f,0.0f); 	glVertex2f(-0.9f,1.25f);
			glTexCoord2f(1.0f,1.0f);	glVertex2f(-0.9f,1.55f);
		glEnd();
		glDisable(GL_TEXTURE_2D);
		glColor3f(0.0f,0.0f,0.0f);
		glBegin(GL_LINE_LOOP);
			glVertex2f(-0.9f,1.55f);
		 	glVertex2f(-0.9f,1.25f);
			glVertex2f(-0.6f,1.25f);
			glVertex2f(-0.6f,1.55f);
		glEnd();
		glBegin(GL_LINE_LOOP);
			glVertex2f(-0.6f,1.55f);
		 	glVertex2f(-0.6f,1.25f);
		 	glVertex2f(-0.3f,1.25f);
			glVertex2f(-0.3f,1.55f);
		glEnd();
		glBegin(GL_LINE_LOOP);
			glVertex2f(-0.3f,1.55f);
			glVertex2f(-0.3f,1.25f);
		 	glVertex2f(-0.0f,1.25f);
			glVertex2f(-0.0f,1.55f);
		glEnd();
		glBegin(GL_LINE_LOOP);
			// The dollar sign
			glVertex2f(-1.2f,1.55f);
			glVertex2f(-1.2f,1.25f);
			glVertex2f(-0.9f,1.25f);
			glVertex2f(-0.9f,1.55f);
		glEnd();
	}
	else if (gameState == 11)
	{ // Dimming from splash screen
		dimAmount += margin;
		glColor3f(1.0f,1.0f,1.0f);
		glEnable(GL_TEXTURE_2D);	
		glBindTexture(GL_TEXTURE_2D, splash);
		glBegin(GL_QUADS);
			glTexCoord2f(0.0f,0.0f);	glVertex2f(-2.8f,-2.1f);
			glTexCoord2f(1.0f,0.0f); 	glVertex2f(+2.8f,-2.1f);
			glTexCoord2f(1.0f,1.0f); 	glVertex2f(+2.8f,2.1f);
			glTexCoord2f(0.0f,1.0f);	glVertex2f(-2.8f,2.1f);
		glEnd();
		glDisable(GL_TEXTURE_2D);

		glEnable(GL_BLEND);
		float alpha = dimAmount/2000.0f;
		glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
		glColor4f(0.11f, 0.52f, 0.0f, alpha);
		glBegin(GL_QUADS);
			glTexCoord2f(0.0f,0.0f);	glVertex2f(-3.2f,-2.45f);
			glTexCoord2f(1.0f,0.0f); 	glVertex2f(+3.2f,-2.45f);
			glTexCoord2f(1.0f,1.0f); 	glVertex2f(+3.2f,2.45f);
			glTexCoord2f(0.0f,1.0f);	glVertex2f(-3.2f,2.45f);
		glEnd();


		if (dimAmount > 2500)
		{
			gameState = 12;
			dimAmount = 0;
		}
		glDisable(GL_BLEND);
	}
	else if (gameState == 42)
	{ // Dimming to gameover
		dimAmount += margin;
		glColor3f(1.0f,1.0f,1.0f);
		glEnable(GL_TEXTURE_2D);	
		glBindTexture(GL_TEXTURE_2D, gameover);
		glBegin(GL_QUADS);
			glTexCoord2f(0.0f,0.0f);	glVertex2f(-2.8f,-1.99f);
			glTexCoord2f(1.0f,0.0f); 	glVertex2f(+2.8f,-1.99f);
			glTexCoord2f(1.0f,1.0f); 	glVertex2f(+2.8f,1.99f);
			glTexCoord2f(0.0f,1.0f);	glVertex2f(-2.8f,1.99f);
		glEnd();
		glDisable(GL_TEXTURE_2D);

		// Draw monehhh
		// ------------
		int a = menu->money / 100;
		int b = (menu->money % 100) / 10;
		int c = (menu->money % 10);

		glBindTexture(GL_TEXTURE_2D, menu->numbers);	
		glBegin(GL_QUADS);
			glTexCoord2f(0.000f+1.0f/11*a,1.0f);	glVertex2f(-0.9f,1.55f);
			glTexCoord2f(0.000f+1.0f/11*a,0.0f); 	glVertex2f(-0.9f,1.25f);
			glTexCoord2f(0.091f+1.0f/11*a,0.0f); 	glVertex2f(-0.6f,1.25f);
			glTexCoord2f(0.091f+1.0f/11*a,1.0f);	glVertex2f(-0.6f,1.55f);
			glTexCoord2f(0.000f+1.0f/11*b,1.0f);	glVertex2f(-0.6f,1.55f);
			glTexCoord2f(0.000f+1.0f/11*b,0.0f); 	glVertex2f(-0.6f,1.25f);
			glTexCoord2f(0.091f+1.0f/11*b,0.0f); 	glVertex2f(-0.3f,1.25f);
			glTexCoord2f(0.091f+1.0f/11*b,1.0f);	glVertex2f(-0.3f,1.55f);
			glTexCoord2f(0.000f+1.0f/11*c,1.0f);	glVertex2f(-0.3f,1.55f);
			glTexCoord2f(0.000f+1.0f/11*c,0.0f); 	glVertex2f(-0.3f,1.25f);
			glTexCoord2f(0.091f+1.0f/11*c,0.0f); 	glVertex2f(-0.0f,1.25f);
			glTexCoord2f(0.091f+1.0f/11*c,1.0f);	glVertex2f(-0.0f,1.55f);
			// The dollar sign
			glTexCoord2f(0.91f,1.0f);	glVertex2f(-1.2f,1.55f);
			glTexCoord2f(0.91f,0.0f); 	glVertex2f(-1.2f,1.25f);
			glTexCoord2f(1.0f,0.0f); 	glVertex2f(-0.9f,1.25f);
			glTexCoord2f(1.0f,1.0f);	glVertex2f(-0.9f,1.55f);
		glEnd();
		glDisable(GL_TEXTURE_2D);
		glColor3f(0.0f,0.0f,0.0f);
		glBegin(GL_LINE_LOOP);
			glVertex2f(-0.9f,1.55f);
		 	glVertex2f(-0.9f,1.25f);
			glVertex2f(-0.6f,1.25f);
			glVertex2f(-0.6f,1.55f);
		glEnd();
		glBegin(GL_LINE_LOOP);
			glVertex2f(-0.6f,1.55f);
		 	glVertex2f(-0.6f,1.25f);
		 	glVertex2f(-0.3f,1.25f);
			glVertex2f(-0.3f,1.55f);
		glEnd();
		glBegin(GL_LINE_LOOP);
			glVertex2f(-0.3f,1.55f);
			glVertex2f(-0.3f,1.25f);
		 	glVertex2f(-0.0f,1.25f);
			glVertex2f(-0.0f,1.55f);
		glEnd();
		glBegin(GL_LINE_LOOP);
			// The dollar sign
			glVertex2f(-1.2f,1.55f);
			glVertex2f(-1.2f,1.25f);
			glVertex2f(-0.9f,1.25f);
			glVertex2f(-0.9f,1.55f);
		glEnd();


		glEnable(GL_BLEND);
		float alpha = 1.0f-dimAmount/2000.0f;
		glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
		glColor4f(0.11f, 0.52f, 0.0f, alpha);
		glBegin(GL_QUADS);
			glTexCoord2f(0.0f,0.0f);	glVertex2f(-3.2f,-2.45f);
			glTexCoord2f(1.0f,0.0f); 	glVertex2f(+3.2f,-2.45f);
			glTexCoord2f(1.0f,1.0f); 	glVertex2f(+3.2f,2.45f);
			glTexCoord2f(0.0f,1.0f);	glVertex2f(-3.2f,2.45f);
		glEnd();

		if (dimAmount > 2000)
		{
			gameState = 43;
			dimAmount = 0;
		}	
		glDisable(GL_BLEND);
	}
	else if (gameState == 12)
	{ // Dimming to menu
		dimAmount += margin;
		menu->drawMenu();
		glEnable(GL_BLEND);
		float alpha = 1.0f-dimAmount/1000.0f;
		glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
		glColor4f(0.11f, 0.52f, 0.0f, alpha);
		glBegin(GL_QUADS);
			glTexCoord2f(0.0f,0.0f);	glVertex2f(-3.2f,-2.45f);
			glTexCoord2f(1.0f,0.0f); 	glVertex2f(+3.2f,-2.45f);
			glTexCoord2f(1.0f,1.0f); 	glVertex2f(+3.2f,2.45f);
			glTexCoord2f(0.0f,1.0f);	glVertex2f(-3.2f,2.45f);
		glEnd();
		
		if (dimAmount > 1000)
		{
			gameState = 0;
			dimAmount = 0;
		}
		glDisable(GL_BLEND);
	}
	else if (gameState == 21)
	{ // Dimming from menu
		dimAmount += margin;
		menu->drawMenu();
		glEnable(GL_BLEND);
		float alpha = dimAmount/1000.0f;
		glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
		glColor4f(0.11f, 0.52f, 0.0f, alpha);
		glBegin(GL_QUADS);
			glTexCoord2f(0.0f,0.0f);	glVertex2f(-3.2f,-2.45f);
			glTexCoord2f(1.0f,0.0f); 	glVertex2f(+3.2f,-2.45f);
			glTexCoord2f(1.0f,1.0f); 	glVertex2f(+3.2f,2.45f);
			glTexCoord2f(0.0f,1.0f);	glVertex2f(-3.2f,2.45f);
		glEnd();
	
		
		if (dimAmount > 1100)
		{
			dwarfs->makeReady(menu->DwarfID,menu->DwarfInfo,menu->WeatherForecast);
			gameState = 22;
			dimAmount = 0;
		}
		glDisable(GL_BLEND);
	}
	else if (gameState == 31)
	{ // Dimming from game
		dimAmount += margin;
		glColor3f(0.52f,0.0f,0.0f);
		glBegin (GL_LINES);            
				glVertex3f(-2.5f, 2.45f, 0);    
				glVertex3f(-2.5f, -2.45f, 0);
				glVertex3f( 2.5f, 2.45f, 0);    
				glVertex3f( 2.5f, -2.45f, 0);
		glEnd();                
		
		// Dwarfs!!!
		dwarfs->drawDwarfs();
		dwarfs->drawEnemies(margin);

		float alpha = dimAmount/1000.0f;
		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
		glColor4f(0.11f, 0.52f, 0.0f, alpha);
		glBegin(GL_QUADS);
			glTexCoord2f(0.0f,0.0f);	glVertex2f(-3.3f,-2.55f);
			glTexCoord2f(1.0f,0.0f); 	glVertex2f(+3.3f,-2.55f);
			glTexCoord2f(1.0f,1.0f); 	glVertex2f(+3.3f,2.55f);
			glTexCoord2f(0.0f,1.0f);	glVertex2f(-3.3f,2.55f);
		glEnd();
	
		
		if (dimAmount > 1100)
		{
			menu->makeReady(dwarfs->DwarfInfo);
			if (gameOver == 1)
				gameState = 12;
			else if (gameOver == -1)
				gameState = 42;
				dimAmount = 0;
		}
		glDisable(GL_BLEND);
	}
	else if (gameState == 22)
	{ // Dimming to game
		dimAmount += margin;
		glColor3f(0.52f,0.0f,0.0f);
		glBegin (GL_LINES);            
				glVertex3f(-2.5f, 2.45f, 0);    
				glVertex3f(-2.5f, -2.45f, 0);
				glVertex3f( 2.5f, 2.45f, 0);    
				glVertex3f( 2.5f, -2.45f, 0);
		glEnd();                
		
		// Dwarfs!!!
		dwarfs->drawDwarfs();


		float alpha = 1.0f - dimAmount/1000.0f;
		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
		glColor4f(0.11f, 0.52f, 0.0f, alpha);
		glBegin(GL_QUADS);
			glTexCoord2f(0.0f,0.0f);	glVertex2f(-3.3f,-2.55f);
			glTexCoord2f(1.0f,0.0f); 	glVertex2f(+3.3f,-2.55f);
			glTexCoord2f(1.0f,1.0f); 	glVertex2f(+3.3f,2.55f);
			glTexCoord2f(0.0f,1.0f);	glVertex2f(-3.3f,2.55f);
		glEnd();
	
		
		if (dimAmount > 1100)
		{
			dwarfs->isReady();
			gameState = 1;
			dimAmount = 0;
		}
		glDisable(GL_BLEND);
	}
    SDL_GL_SwapBuffers();     
	return;
}

int main( int argc, char* argv[] )
{
	// Seed the random generator 
	srand((unsigned)time(NULL));

	SDL_Surface* TheWindow = NULL;         
 
	SDL_Init(SDL_INIT_VIDEO);

	const SDL_VideoInfo* VideoInfo = SDL_GetVideoInfo();
	int Options = 0;
	if (VideoInfo->hw_available)
		Options = SDL_HWSURFACE;
	else
		Options |= SDL_SWSURFACE;
	if (VideoInfo->blit_hw)
		Options |= SDL_HWACCEL;

    SDL_GL_SetAttribute( SDL_GL_DOUBLEBUFFER, 1 );         
    SDL_GL_SetAttribute( SDL_GL_DEPTH_SIZE,   16);       
    SDL_GL_SetAttribute( SDL_GL_STENCIL_SIZE, 0);      
    SDL_GL_SetAttribute( SDL_GL_ACCUM_RED_SIZE, 0);     
    SDL_GL_SetAttribute( SDL_GL_ACCUM_GREEN_SIZE, 0);
    SDL_GL_SetAttribute( SDL_GL_ACCUM_BLUE_SIZE, 0);
    SDL_GL_SetAttribute( SDL_GL_ACCUM_ALPHA_SIZE, 0);

	TheWindow = SDL_SetVideoMode(800,600,16,SDL_OPENGL | SDL_HWPALETTE | Options);

	SDL_WM_SetCaption ("Weather, the Dwarf Slayer","The Game");

	// Set up ViewPort
	glViewport(0, 0, 800, 600);				
  	glMatrixMode(GL_PROJECTION);				
	glLoadIdentity();			
	gluPerspective(45.0f,(GLfloat)800/(GLfloat)600,0.1f,100.0f);
	glMatrixMode(GL_MODELVIEW);	
	glLoadIdentity();

	// Now change some OpenGL setings
	glShadeModel(GL_SMOOTH);
	glClearColor(0.11f, 0.52f, 0.0f, 0.5f);
	glClearDepth(1.0f);				
	glEnable(GL_DEPTH_TEST);				
	glDepthFunc(GL_LEQUAL);	
	glAlphaFunc(GL_GREATER,0.1f);
	glEnable(GL_ALPHA_TEST);
	glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);	

	// Classes
	menu = new Menu();
	dwarfs = new Dwarfs();

	// Loop Variables;
    SDL_Event event;
	bool done = false;
	int lMouseHeld = false;
	int rMouseHeld = false;
	gameState = 10; // Start is 10
	dimAmount = 0;

	BuildTexture("splash.gif",splash);

	BuildTexture("gameover.jpg",gameover);
	DWORD lastTickCount = GetTickCount();
	DWORD thisTickCount;
	// Teh Main loop
	while(!done)                                       
    {
		thisTickCount = GetTickCount();
		margin = thisTickCount - lastTickCount;
		lastTickCount = thisTickCount;

        while(SDL_PollEvent(&event))                  
        {
            switch (event.type)                        
            {
                case SDL_QUIT:                            
                    done = true;                          
                    break;
				case SDL_MOUSEMOTION:
					if (gameState == 1)
					{
						if (dwarfs->mouseRectExists)
							dwarfs->updMouseRect(event.motion.x,event.motion.y);
					}
					else if (gameState == 0)
					{
						menu->updMouseRect(event.motion.x,event.motion.y);
					}
				break;
 				case SDL_MOUSEBUTTONDOWN:
					if (gameState == 1)
					{
						if (event.button.button == SDL_BUTTON_RIGHT && !rMouseHeld) 
						{
							dwarfs->deSelect();
							rMouseHeld = true;
						}
						if (event.button.button == SDL_BUTTON_LEFT && !lMouseHeld) 
						{
							lMouseHeld = true;
							if (!dwarfs->mouseRectExists && !dwarfs->dwarfsSelected)
								dwarfs->newMouseRect(event.button.x,event.button.y);
							else 
								dwarfs->selectionHead(event.button.x,event.button.y);
						}
					}
					else if (gameState == 0)
					{
						if (event.button.button == SDL_BUTTON_LEFT && !lMouseHeld) 
						{
							lMouseHeld = true;
							if( menu->mouseClick(event.button.x,event.button.y))
							{
								gameState = 21;
								dimAmount = 0;	
							}
						}
					}
				break;
				case SDL_MOUSEBUTTONUP:
					if (gameState == 1)
					{
						if (event.button.button == SDL_BUTTON_RIGHT) 
						{
							rMouseHeld = false;
						}
						if (event.button.button == SDL_BUTTON_LEFT) 
						{
							lMouseHeld = false;
							if (!dwarfs->dwarfsSelected)
								dwarfs->delMouseRect();
						}	
					}
					else if (gameState == 0)
					{
						if (event.button.button == SDL_BUTTON_LEFT) 
						{
							lMouseHeld = false;
						}
					}
				break;  
				case SDL_KEYDOWN:    
					switch(event.key.keysym.sym)                     
					{
					case SDLK_ESCAPE:                                 
						done = true;  
					break;
         			default:                                   
						 break;         
					}  
					if (gameState == 10)
					{
						gameState = 11;
						dimAmount = 0;					
					}
 					else if (gameState == 43)
					{
						done = true;				
					}
				break;
               default:                                
               break;                       
            } 
        } 
		mainLoop();                                     
    } 
	delete menu;
	delete dwarfs;
	SDL_Quit();

	return 0;
}