#ifndef dwarf_h_included
#define dwarf_h_included

#include "dwarfstruct.h"

struct Hnit {
	float x;
	float y;
	short a;
};

struct Enemy {
	float xPos;
	float yPos;
	float xDest;
	float yDest;
	float radius;
	Hnit *hnit;
	int speed;
	int status;
	DWORD timer;
};


class Dwarfs {
private:
	int dwarfsLeft;
	int weatherForecast;
	int numberOfEnemies;

	struct Rect {
		float xPos;
		float yPos;
		float xHead;
		float yHead;
	};
	
	Rect mouseRect;
	Enemy* enemies;
	GLuint *DwarfID;

	DWORD lastEnemyTime;

	GLuint Labs;
	GLuint HQ;
	void drawRain(const float x, const float y,const float r, DWORD margin,int nr);
	void drawSnow(const float x, const float y,const float r, DWORD margin,int nr);
	void drawLightning(const float x, const float y,const float r, DWORD margin,int nr);
	GLuint sWind;

	int randArray[10];
public:
	Dwarf* DwarfInfo;

	void drawEnemies(DWORD margin);
	void drawDwarfs();
	int moveDwarfs(const DWORD margin);
	void handleEnemies(const DWORD margin);

	bool mouseRectExists;
	bool dwarfsSelected;
	void newMouseRect(const int x,const int y);
	void updMouseRect(const int x,const int y);
	void delMouseRect();
	void deSelect();

	void selectionHead(const int x, const int y);

	void makeReady(GLuint *DwarfID,Dwarf* DwarfInfo, int forecast);
	void isReady();
	// Constructor and deconstructor
		Dwarfs();
		~Dwarfs();

};


#endif