#include "main.h"
#include "dwarfs.h"
#include "functions.h"

Dwarfs::Dwarfs ()
{
	mouseRectExists = false;
	mouseRect.yPos = 0;
	mouseRect.xPos = 0;
	mouseRect.yHead = 0;
	mouseRect.xHead = 0;
	dwarfsSelected = false;
	dwarfsLeft = 10;

	BuildTexture("swind.gif",sWind);;
	BuildTexture("labs.gif",Labs);
	BuildTexture("hq.gif",HQ);
	enemies = new Enemy[6];

	for (int i = 0; i <10; i++)
		randArray[i] = rand() % 10;
}

void Dwarfs::makeReady(GLuint *ptrDwarfID,Dwarf *ptrDwarfInfo,int forecast)
{
	dwarfsSelected = false;
	mouseRectExists = false;
	mouseRect.yPos = 0;
	mouseRect.xPos = 0;
	mouseRect.yHead = 0;
	mouseRect.xHead = 0;
	
	weatherForecast = forecast;
	DwarfID = ptrDwarfID;
	DwarfInfo = ptrDwarfInfo;
	numberOfEnemies = 0;

	// Fill in dwarf info random
	for (int i = 0; i < dwarfsLeft; i++)
	{
		if (DwarfInfo[i].status != 6)
		{
			float xr = (rand()%300)/100.0f;
			float yr = (rand()%30)/100.0f;
			DwarfInfo[i].xPos = -2.65f-yr;
			DwarfInfo[i].yPos =  0.7f-xr;
		}
		else 
		{
			DwarfInfo[i].xPos = -5.5f;
			DwarfInfo[i].yPos =  5.5f;
		}
		DwarfInfo[i].xDest = 0.0f;
		DwarfInfo[i].yDest = 0.0f;
		DwarfInfo[i].selected = false;
		DwarfInfo[i].speed = 1;
	}

	// Fill in enemy info
	for (i = 0; i < 6; i++)
	{
		enemies[i].status = 0;
	}

	lastEnemyTime = 0;
}

void Dwarfs::isReady()
{
	lastEnemyTime = 0;
}

int Dwarfs::moveDwarfs(const DWORD margin)
{
	float moveMargin = 0.00061f*margin;
	float x,y, lengd;
	int i;
	for (i = 0; i < dwarfsLeft; i++)
	{
		if (DwarfInfo[i].xDest != 0.0f)
		{
			x = DwarfInfo[i].xDest-DwarfInfo[i].xPos;
			y = DwarfInfo[i].yDest-DwarfInfo[i].yPos;
			lengd = static_cast<float> (sqrt(x*x+y*y));

			if (lengd < 0.01f)
			{ // Vi erum komin
				DwarfInfo[i].xDest = 0.0f;
			}
			else
			{
				// Breytum  einingarvigur
				x = 1/lengd * x;
				y = 1/lengd * y;

				DwarfInfo[i].xPos += x*moveMargin*DwarfInfo[i].speed;
				DwarfInfo[i].yPos += y*moveMargin*DwarfInfo[i].speed;
			}
		}
	}
	int count = 0;
	for (i = 0; i < dwarfsLeft; i++)
	{
		if (DwarfInfo[i].xPos < 2.6f && DwarfInfo[i].status != 6)
		{
			return 0;
		}
		if (DwarfInfo[i].status == 6)
			count++;

	}
	if (count == dwarfsLeft)
		return -1;
	else 
		return 1;
}

void Dwarfs::handleEnemies(const DWORD margin)
{
	if ((lastEnemyTime == 0 || lastEnemyTime > 2000) && numberOfEnemies < 6)
	{	// Spawn enemy
		// First we come up with some random type
		int rnr = rand() % 6 + 1;
		if (rnr > 5)
			enemies[numberOfEnemies].status = weatherForecast;
		else
			enemies[numberOfEnemies].status = rnr;

		enemies[numberOfEnemies].xPos = 3.2f - (rand()%480)/100.0f;
		enemies[numberOfEnemies].yPos = 2.45f - (rand()%500)/100.0f;
		enemies[numberOfEnemies].xDest = 3.2f - (rand()%480)/100.0f;
		enemies[numberOfEnemies].yDest = 2.45f - (rand()%500)/100.0f;

		enemies[numberOfEnemies].radius = (rand()%7+3)/10.0f;

		enemies[numberOfEnemies].speed= rand()%3+1;

		if (enemies[numberOfEnemies].xPos+enemies[numberOfEnemies].radius > 2.5f)
			enemies[numberOfEnemies].xPos = 2.5f - enemies[numberOfEnemies].radius;
		
		lastEnemyTime = 0;

		if (enemies[numberOfEnemies].status == 2)
		{
			enemies[numberOfEnemies].hnit = new Hnit[static_cast<int>(48*enemies[numberOfEnemies].radius)+1];
			for (int a = 0; a < static_cast<int>(48*enemies[numberOfEnemies].radius)+1; a++)
			{
				double lengd;
				do
				{
					enemies[numberOfEnemies].hnit[a].x = enemies[numberOfEnemies].radius- (rand()%200)/100.0f*enemies[numberOfEnemies].radius;
					enemies[numberOfEnemies].hnit[a].y = enemies[numberOfEnemies].radius-(rand()%200)/100.0f*enemies[numberOfEnemies].radius;
					float x = enemies[numberOfEnemies].hnit[a].x;
					float y = enemies[numberOfEnemies].hnit[a].y;
					lengd = sqrt(x*x+y*y);
				} 
				while (lengd > enemies[numberOfEnemies].radius);
				enemies[numberOfEnemies].hnit[a].a = rand () % 3;
			}
		}
		numberOfEnemies++;
	}

	lastEnemyTime += margin;

	// Move enemies
	float moveMargin = 0.00031f*margin;
	float x,y, lengd;
	int i;
	for (i = 0; i < numberOfEnemies; i++)
	{
		x = enemies[i].xDest-enemies[i].xPos;
		y = enemies[i].yDest-enemies[i].yPos;
		lengd = static_cast<float> (sqrt(x*x+y*y));

		if (lengd < 0.01f)
		{ // Vi erum komin
			enemies[i].xDest = 3.1f - (rand()%480)/100.0f;
			enemies[i].yDest = 2.45f - (rand()%500)/100.0f;
		}
		else
		{
			// Breytum  einingarvigur
			x = 1/lengd * x;
			y = 1/lengd * y;

			enemies[i].xPos += x*moveMargin*enemies[i].speed;
			enemies[i].yPos += y*moveMargin*enemies[i].speed;
		}
	}

	// Check Collisions
	for (i = 0; i < numberOfEnemies; i++)
	{
		for (int a = 0; a < dwarfsLeft; a++)
		{
			x = enemies[i].xPos-DwarfInfo[a].xPos;
			y = enemies[i].yPos-DwarfInfo[a].yPos;
			lengd = static_cast<float> (sqrt(x*x+y*y));

			if (lengd < enemies[i].radius && enemies[i].status != 6)
			{ // gv N deyr hann
				if (enemies[i].status != DwarfInfo[a].status && !(enemies[i].status == 1 && DwarfInfo[a].status == 2))
				{
					DwarfInfo[a].status = 6;
					DwarfInfo[a].selected = false;
					if (enemies[i].status == 5)
					{ // Hann fkur til andskotans
						DwarfInfo[a].xDest = 5.0f;
						DwarfInfo[a].yDest = 5.0f;
						DwarfInfo[a].speed = 8;
					}
					else
						DwarfInfo[a].xDest = 0.0f;
				}
			}
		}
	}

}

void Dwarfs::drawEnemies(DWORD margin)
{
	int i;
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
	// If the dwarf is selected
	for (i = 0; i < numberOfEnemies; i++)
	{
		if (enemies[i].status == 1)
		{ // Rain	GLuint tUmbrella;
			drawRain(enemies[i].xPos,enemies[i].yPos,enemies[i].radius,margin,i);
			glColor4f(0.15f,0.15f,0.15f,0.5f);
		} 
		else if (enemies[i].status == 2)
		{ // Eldingar
			drawLightning(enemies[i].xPos,enemies[i].yPos,enemies[i].radius,margin,i);
			glColor4f(0.15f,0.15f,0.15f,0.5f);
		}
			else if (enemies[i].status == 3)
			{ // Snow
				drawSnow(enemies[i].xPos,enemies[i].yPos,enemies[i].radius,margin,i);
				glColor4f(1.0f,1.0f,1.0f,0.5f);
			}
			else if (enemies[i].status == 4)
			{ // Sun
				glColor4f(0.85f,0.80f,0.0f,0.5f);
			}
			else if (enemies[i].status == 5)
			{ // Wind
				glColor4f(1.0f,1.0f,1.0f,0.5f);
				glEnable(GL_TEXTURE_2D);
				glBindTexture(GL_TEXTURE_2D, sWind);
			}
			glBegin(GL_TRIANGLE_FAN);
				glTexCoord2f(0.5f,0.5f);	glVertex2f(enemies[i].xPos,enemies[i].yPos);
				glTexCoord2f(0.91f,0.59f);	glVertex2d(0.965925826*enemies[i].radius+enemies[i].xPos,	0.258819045*enemies[i].radius+enemies[i].yPos);
				glTexCoord2f(0.82f,0.68f);	glVertex2d(0.866025404*enemies[i].radius+enemies[i].xPos,	0.5*enemies[i].radius+enemies[i].yPos);
				glTexCoord2f(0.75f,0.75f);	glVertex2d(0.707106781*enemies[i].radius+enemies[i].xPos,	0.707106781*enemies[i].radius+enemies[i].yPos);
				glTexCoord2f(0.68f,0.82f);	glVertex2d(0.5*enemies[i].radius+enemies[i].xPos,	0.866025404*enemies[i].radius+enemies[i].yPos);
				glTexCoord2f(0.59f,0.91f);	glVertex2d(0.258819045*enemies[i].radius+enemies[i].xPos,	0.965925826*enemies[i].radius+enemies[i].yPos);
				glTexCoord2f(0.5f,1.0f);	glVertex2d(0*enemies[i].radius+enemies[i].xPos,	1*enemies[i].radius+enemies[i].yPos);
				glTexCoord2f(0.41f,0.91f);	glVertex2d(-0.258819045*enemies[i].radius+enemies[i].xPos,	0.965925826*enemies[i].radius+enemies[i].yPos);
				glTexCoord2f(0.32f,0.82f);	glVertex2d(-0.5*enemies[i].radius+enemies[i].xPos,	0.866025404*enemies[i].radius+enemies[i].yPos);
				glTexCoord2f(0.25f,0.75f);	glVertex2d(-0.707106781*enemies[i].radius+enemies[i].xPos,	0.707106781*enemies[i].radius+enemies[i].yPos);
				glTexCoord2f(0.18f,0.68f);	glVertex2d(-0.866025404*enemies[i].radius+enemies[i].xPos,	0.5*enemies[i].radius+enemies[i].yPos);
				glTexCoord2f(0.09f,0.59f);	glVertex2d(-0.965925826*enemies[i].radius+enemies[i].xPos,	0.258819045*enemies[i].radius+enemies[i].yPos);
				glTexCoord2f(0.0f,0.5f);	glVertex2d(-1*enemies[i].radius+enemies[i].xPos,	0*enemies[i].radius+enemies[i].yPos);
				glTexCoord2f(0.09f,0.41f);	glVertex2d(-0.965925826*enemies[i].radius+enemies[i].xPos,	-0.258819045*enemies[i].radius+enemies[i].yPos);
				glTexCoord2f(0.18f,0.32f);	glVertex2d(-0.866025404*enemies[i].radius+enemies[i].xPos,	-0.5*enemies[i].radius+enemies[i].yPos);
				glTexCoord2f(0.25f,0.25f);	glVertex2d(-0.707106781*enemies[i].radius+enemies[i].xPos,	-0.707106781*enemies[i].radius+enemies[i].yPos);
				glTexCoord2f(0.32f,0.18f);	glVertex2d(-0.5*enemies[i].radius+enemies[i].xPos,	-0.866025404*enemies[i].radius+enemies[i].yPos);
				glTexCoord2f(0.41f,0.09f);	glVertex2d(-0.258819045*enemies[i].radius+enemies[i].xPos,	-0.965925826*enemies[i].radius+enemies[i].yPos);
				glTexCoord2f(0.5f,0.0f);	glVertex2d(0*enemies[i].radius+enemies[i].xPos,	-1*enemies[i].radius+enemies[i].yPos);
				glTexCoord2f(0.59f,0.09f);	glVertex2d(0.258819045*enemies[i].radius+enemies[i].xPos,	-0.965925826*enemies[i].radius+enemies[i].yPos);
				glTexCoord2f(0.68f,0.18f);	glVertex2d(0.5*enemies[i].radius+enemies[i].xPos,	-0.866025404*enemies[i].radius+enemies[i].yPos);
				glTexCoord2f(0.75f,0.25f);	glVertex2d(0.707106781*enemies[i].radius+enemies[i].xPos,	-0.707106781*enemies[i].radius+enemies[i].yPos);
				glTexCoord2f(0.82f,0.32f);	glVertex2d(0.866025404*enemies[i].radius+enemies[i].xPos,	-0.5*enemies[i].radius+enemies[i].yPos);
				glTexCoord2f(0.91f,0.41f);	glVertex2d(0.965925826*enemies[i].radius+enemies[i].xPos,	-0.258819045*enemies[i].radius+enemies[i].yPos);
				glTexCoord2f(1.0f,0.5f);	glVertex2d(1*enemies[i].radius+enemies[i].xPos,	0*enemies[i].radius+enemies[i].yPos);
				glTexCoord2f(0.91f,0.59f);	glVertex2d(0.965925826*enemies[i].radius+enemies[i].xPos,	0.258819045*enemies[i].radius+enemies[i].yPos);
			glEnd();

		glColor4f(0.0f,0.0f,0.0f,1.0f);
		// Draw the line arround
		glBegin(GL_LINE_LOOP);
			glVertex2d(0.965925826*enemies[i].radius+enemies[i].xPos,	0.258819045*enemies[i].radius+enemies[i].yPos);
			glVertex2d(0.866025404*enemies[i].radius+enemies[i].xPos,	0.5*enemies[i].radius+enemies[i].yPos);
			glVertex2d(0.707106781*enemies[i].radius+enemies[i].xPos,	0.707106781*enemies[i].radius+enemies[i].yPos);
			glVertex2d(0.5*enemies[i].radius+enemies[i].xPos,	0.866025404*enemies[i].radius+enemies[i].yPos);
			glVertex2d(0.258819045*enemies[i].radius+enemies[i].xPos,	0.965925826*enemies[i].radius+enemies[i].yPos);
			glVertex2d(0*enemies[i].radius+enemies[i].xPos,	1*enemies[i].radius+enemies[i].yPos);
			glVertex2d(-0.258819045*enemies[i].radius+enemies[i].xPos,	0.965925826*enemies[i].radius+enemies[i].yPos);
			glVertex2d(-0.5*enemies[i].radius+enemies[i].xPos,	0.866025404*enemies[i].radius+enemies[i].yPos);
			glVertex2d(-0.707106781*enemies[i].radius+enemies[i].xPos,	0.707106781*enemies[i].radius+enemies[i].yPos);
			glVertex2d(-0.866025404*enemies[i].radius+enemies[i].xPos,	0.5*enemies[i].radius+enemies[i].yPos);
			glVertex2d(-0.965925826*enemies[i].radius+enemies[i].xPos,	0.258819045*enemies[i].radius+enemies[i].yPos);
			glVertex2d(-1*enemies[i].radius+enemies[i].xPos,	0*enemies[i].radius+enemies[i].yPos);
			glVertex2d(-0.965925826*enemies[i].radius+enemies[i].xPos,	-0.258819045*enemies[i].radius+enemies[i].yPos);
			glVertex2d(-0.866025404*enemies[i].radius+enemies[i].xPos,	-0.5*enemies[i].radius+enemies[i].yPos);
			glVertex2d(-0.707106781*enemies[i].radius+enemies[i].xPos,	-0.707106781*enemies[i].radius+enemies[i].yPos);
			glVertex2d(-0.5*enemies[i].radius+enemies[i].xPos,	-0.866025404*enemies[i].radius+enemies[i].yPos);
			glVertex2d(-0.258819045*enemies[i].radius+enemies[i].xPos,	-0.965925826*enemies[i].radius+enemies[i].yPos);
			glVertex2d(0*enemies[i].radius+enemies[i].xPos,	-1*enemies[i].radius+enemies[i].yPos);
			glVertex2d(0.258819045*enemies[i].radius+enemies[i].xPos,	-0.965925826*enemies[i].radius+enemies[i].yPos);
			glVertex2d(0.5*enemies[i].radius+enemies[i].xPos,	-0.866025404*enemies[i].radius+enemies[i].yPos);
			glVertex2d(0.707106781*enemies[i].radius+enemies[i].xPos,	-0.707106781*enemies[i].radius+enemies[i].yPos);
			glVertex2d(0.866025404*enemies[i].radius+enemies[i].xPos,	-0.5*enemies[i].radius+enemies[i].yPos);
			glVertex2d(0.965925826*enemies[i].radius+enemies[i].xPos,	-0.258819045*enemies[i].radius+enemies[i].yPos);
			glVertex2d(1*enemies[i].radius+enemies[i].xPos,	0*enemies[i].radius+enemies[i].yPos);
			glVertex2d(0.965925826*enemies[i].radius+enemies[i].xPos,	0.258819045*enemies[i].radius+enemies[i].yPos);
		glEnd();
		glDisable(GL_TEXTURE_2D);
	}
	glDisable(GL_BLEND);



}
void Dwarfs::drawDwarfs()
{	
	int i;
	// If the dwarf is selected
	glColor3f(0.85f,0.80f,0.0f);
	for (i = 0; i < dwarfsLeft; i++)
	{
		if (DwarfInfo[i].selected)
		{
		glBegin(GL_QUADS);
			glVertex2f(DwarfInfo[i].xPos-0.084f,DwarfInfo[i].yPos-0.05f);
			glVertex2f(DwarfInfo[i].xPos+0.084f,DwarfInfo[i].yPos-0.05f);
			glVertex2f(DwarfInfo[i].xPos+0.084f,DwarfInfo[i].yPos+0.05f);
			glVertex2f(DwarfInfo[i].xPos-0.084f,DwarfInfo[i].yPos+0.05f);
		glEnd();
		}
	}

	// Draw a line where the dwarf is heading
	glEnable(GL_LINE_STIPPLE);
    glLineStipple(1,0x5555);
	glBegin(GL_LINES);
		for (i = 0; i < dwarfsLeft; i++)
		{
			if (DwarfInfo[i].xDest != 0.0f && DwarfInfo[i].status != 6)
			{
				glVertex2f(DwarfInfo[i].xPos,DwarfInfo[i].yPos);
				glVertex2f(DwarfInfo[i].xDest,DwarfInfo[i].yDest);	
			}
		}
	glEnd();
	glDisable(GL_LINE_STIPPLE);

	glColor3f(1.0f,1.0f,1.0f);
	glEnable(GL_TEXTURE_2D);	
	// Draw the lab
	glBindTexture(GL_TEXTURE_2D, Labs);
	glBegin(GL_QUADS);
		glTexCoord2f(0.0f,0.0f);	glVertex2f(-3.3f,0.5f);
		glTexCoord2f(1.0f,0.0f); 	glVertex2f(-2.3f,0.5f);
		glTexCoord2f(1.0f,1.0f); 	glVertex2f(-2.3f,2.5f);
		glTexCoord2f(0.0f,1.0f);	glVertex2f(-3.3f,2.5f);
	glEnd();
	// Draw the hq
	glBindTexture(GL_TEXTURE_2D, HQ);
	glBegin(GL_QUADS);
		glTexCoord2f(1.0f,0.0f);	glVertex2f( 3.3f,0.5f);
		glTexCoord2f(0.0f,0.0f); 	glVertex2f( 2.3f,0.5f);
		glTexCoord2f(0.0f,1.0f); 	glVertex2f( 2.3f,2.5f);
		glTexCoord2f(1.0f,1.0f);	glVertex2f( 3.3f,2.5f);
	glEnd();
	for (i = 0; i < dwarfsLeft; i++)
	{
		glBindTexture(GL_TEXTURE_2D, DwarfID[DwarfInfo[i].status]);
		glBegin(GL_QUADS);
			glTexCoord2f(0.0f,0.0f);	glVertex2f(DwarfInfo[i].xPos-0.1f,DwarfInfo[i].yPos);
			glTexCoord2f(1.0f,0.0f); 	glVertex2f(DwarfInfo[i].xPos+0.1f,DwarfInfo[i].yPos);
			glTexCoord2f(1.0f,1.0f); 	glVertex2f(DwarfInfo[i].xPos+0.1f,DwarfInfo[i].yPos+0.3f);
			glTexCoord2f(0.0f,1.0f);	glVertex2f(DwarfInfo[i].xPos-0.1f,DwarfInfo[i].yPos+0.3f);
		glEnd();
	}
	glDisable(GL_TEXTURE_2D);

	// Draw the mouserectangle if it exists
	if (mouseRectExists)
	{
		glBegin(GL_LINE_STRIP);
			glVertex2f(mouseRect.xPos,mouseRect.yPos);
			glVertex2f(mouseRect.xHead,mouseRect.yPos);	
			glVertex2f(mouseRect.xHead,mouseRect.yHead);					
			glVertex2f(mouseRect.xPos,mouseRect.yHead);	
			glVertex2f(mouseRect.xPos,mouseRect.yPos);
		glEnd();
	}
}

void Dwarfs::newMouseRect(const int x, const int y)
{
	mouseRectExists = true;
	mouseRect.yPos = 2.45f-4.9f/600*y;
	mouseRect.xPos = -(3.20f-6.4f/800*x);
	mouseRect.yHead = 2.45f-4.9f/600*y;
	mouseRect.xHead = -(3.20f-6.4f/800*x);
}

void Dwarfs::drawLightning(const float x, const float y,const float r, DWORD margin,int nr)
{
	if (enemies[nr].timer > 900)
		enemies[nr].timer = 0;
	enemies[nr].timer += margin;

	glColor3f(0.94f,1.0f,0.16f);

	for (int a = 0; a < static_cast<int>(48*enemies[nr].radius)+1; a++)
	{
		if ((enemies[nr].timer < 300 && enemies[nr].hnit[a].a == 0) ||
			(enemies[nr].timer <= 600 && enemies[nr].timer >= 300 && enemies[nr].hnit[a].a == 1) ||
			(enemies[nr].timer > 600 && enemies[nr].hnit[a].a == 2))
		{
			glBegin(GL_LINE_STRIP);
				glVertex2f(enemies[nr].hnit[a].x+x, enemies[nr].hnit[a].y+y);
				glVertex2f(enemies[nr].hnit[a].x+x-0.055f, enemies[nr].hnit[a].y+y-0.05f);
				glVertex2f(enemies[nr].hnit[a].x+x-0.01f, enemies[nr].hnit[a].y+y-0.05f);
				glVertex2f(enemies[nr].hnit[a].x+x-0.06f, enemies[nr].hnit[a].y+y-0.1f);
				glVertex2f(enemies[nr].hnit[a].x+x-0.015f, enemies[nr].hnit[a].y+y-0.1f);
				glVertex2f(enemies[nr].hnit[a].x+x-0.165f, enemies[nr].hnit[a].y+y-0.2f);
			glEnd();
		}
	}

}

void Dwarfs::drawRain(const float x, const float y,const float r, DWORD margin, int nr)
{
	if (enemies[nr].timer > 2000)
		enemies[nr].timer = 0;
	enemies[nr].timer += margin;
	
	double addition = 0.2f*enemies[nr].timer/1800.0f;

	glColor3f(0.0f,0.56f,0.77f);
	double a,b;
	glBegin(GL_LINES);
	int counta = 0;
		for (a = -0.7*r; a < +0.7*r; a += 0.05)
		{
			// Vi hfum v lnu me 45 halla gegnum hringinn
			// jafna hennar er y=1*a
			for (b = a+0.707*(r+0.3)-addition+0.01*(randArray[counta % 10])-0.05; b > a-0.707*r; b -= 0.1)
			{		
				if ( b < a+sqrt(-4*a*a+2*r*r)/2 && b > a-sqrt(-4*a*a+2*r*r)/2)
				{
					glVertex2d(b+x+0.03,b-2*a+y+0.03);
					glVertex2d(b+x-0.03,b-2*a+y-0.03);
				}
			}
			counta++;
		}
	glEnd();
}

void Dwarfs::drawSnow(const float x, const float y,const float r, DWORD margin, int nr)
{
	if (enemies[nr].timer > 2000)
		enemies[nr].timer = 0;
	enemies[nr].timer += margin;
	
	double addition = 0.2f*enemies[nr].timer/1800.0f;

	glColor3f(1.0f,1.0f,1.0f);
	double a,b;
	glBegin(GL_LINES);
	int counta = 0;
		for (a = -0.7*r; a < +0.7*r; a += 0.05)
		{;	
			// Vi hfum v lnu me 45 halla gegnum hringinn
			// jafna hennar er y=1*a
			int countb = 0;
			for (b = a+0.707*(r+0.3)-addition+0.01*(randArray[counta % 10])-0.05; b > a-0.707*r; b -= 0.1)
			{		
				if ( b < a+sqrt(-4*a*a+2*r*r)/2 && b > a-sqrt(-4*a*a+2*r*r)/2)
				{
					glVertex2d(b+x,b-2*a+y+0.02);
					glVertex2d(b+x,b-2*a+y-0.02);
					glVertex2d(b+x+0.02,b-2*a+y);
					glVertex2d(b+x-0.02,b-2*a+y);
					glVertex2d(b+x+0.02,b-2*a+y-0.02);
					glVertex2d(b+x-0.02,b-2*a+y+0.02);
					glVertex2d(b+x+0.02,b-2*a+y-0.02);
					glVertex2d(b+x+0.02,b-2*a+y-0.02);
					countb++;
				}
			}
			counta++;
		}
	glEnd();
}

void Dwarfs::updMouseRect(const int x, const int y)
{
	mouseRect.yHead = 2.45f-4.9f/600*y;
	mouseRect.xHead = -(3.20f-6.4f/800*x);
}

void Dwarfs::delMouseRect()
{
	mouseRectExists = false;
	dwarfsSelected = false;
	// Afveljum alla og Athugum hvort vi vldum einhverja nja
	for (int i = 0; i < dwarfsLeft; i++)
	{
		if (DwarfInfo[i].status != 6)
		{
			DwarfInfo[i].selected = false;
		
			bool xCollided = false;
			bool yCollided = false;
			if (mouseRect.xHead >  mouseRect.xPos)
			{
				if (DwarfInfo[i].xPos < mouseRect.xHead && DwarfInfo[i].xPos > mouseRect.xPos)  
					xCollided = true;
			}
			else if (mouseRect.xHead < mouseRect.xPos)
			{
				if (DwarfInfo[i].xPos > mouseRect.xHead && DwarfInfo[i].xPos < mouseRect.xPos)  
					xCollided = true;
			}

			if (mouseRect.yHead >  mouseRect.yPos)
			{
				if (DwarfInfo[i].yPos < mouseRect.yHead && DwarfInfo[i].yPos > mouseRect.yPos)  
					yCollided = true;
			}
			else if (mouseRect.yHead <  mouseRect.yPos)
			{
				if (DwarfInfo[i].yPos > mouseRect.yHead && DwarfInfo[i].yPos < mouseRect.yPos)  
					yCollided = true;
			}

			if (xCollided && yCollided)
			{
				DwarfInfo[i].selected = true;
				dwarfsSelected = true;
			}
		}
	}
}

void Dwarfs::selectionHead(const int x, const int y)
{
	int a = 0;
	int b = 0;
	// Vi getum ekki fari  hsin
	if ((x < -2.3f && x > -3.3f) &&
		(y <  2.5f && y >  0.5f))
		return;
	if ((x >  2.3f && x <  3.3f) &&
		(y <  2.5f && y >  0.5f))
		return;
	for (int i = 0; i < dwarfsLeft; i++)
	{
		if (DwarfInfo[i].selected != 0)
		{
			if (DwarfInfo[i].yDest < 0) 
				DwarfInfo[i].yDest = 2.45f-4.9f/600*y+0.2f*b;
			else 
				DwarfInfo[i].yDest = 2.45f-4.9f/600*y-0.2f*b;
			DwarfInfo[i].xDest= -(3.20f-6.4f/800*x)+0.2f*a;
			if (a % 2 == 1)
			{
				b++;
				a=0;
			}
			else
				a++;
		}
	}
}

void Dwarfs::deSelect()
{
	for (int i = 0; i < dwarfsLeft; i++)
	{
		DwarfInfo[i].selected = 0;
	}
	dwarfsSelected = false;
}

Dwarfs::~Dwarfs ()
{
	delete [] DwarfInfo;
	delete [] DwarfID;
	delete [] enemies;
}